;Saves a TGA screenshot (assumes mode 13h).

SCREENSHOT
  pusha
  pushf
  push ds

  push cs
  pop  ds

;read palette

  mov  ax,255
  mov  di,PALETTE+256*3-1
PALREAD
  mov  dx,3C7h
  out  dx,al
  inc  dx
  inc  dx
  mov  cx,3
  push ax
PALRGB
  in   al,dx
  shl  al,2
  mov  [di],al  ; [di] = b*4 g*4 r*4
  dec  di
  loop PALRGB
  pop  ax
  dec  ax
  jns  PALREAD

;increase filename number

  mov  di,FILENAME + (HEADER-FILENAME) - 5
INCNAME
  inc  byte[di]
  cmp  byte[di],':'
  jb   ENDINCNAME
  mov  byte[di],'0'
  dec  di
  jmp  INCNAME
ENDINCNAME

;write the TGA file and return

  mov  ah,3Ch  ; create file
  mov  dx,FILENAME
  xor  cx,cx
  int  21h

  xchg ax,bx   ; bx=handle

  mov  ah,40h  ; write header and palette
  mov  dx,HEADER
  mov  cx,18+256*3
  int  21h

  push 0A000h
  pop  ds

  mov  ah,40h  ; write pixels
  cwd          ; dx=0
  mov  cx,320*200
  int  21h

  mov  ah,3Eh  ; close file
  int  21h

  pop  ds
  popf
  popa
  ret

FILENAME db "0000/.tga" ;,0
HEADER   db 0,1,1
         dw 0,256
         db 24
         dw 0,0,320,200
         db 8,00100000b

section .bss align=1
PALETTE resb 256*3
